/************************************
        Extended Kalman Filter
        Matrix operations

        V. Smidl

Rev. 30.8.2010

30.8.2010      Prvni verze

*************************************/

#define qAU 14
#define qD 14
#define qCh 14

#define int16 int                     // short int
#define int32 long                    // int

/* Matrix multiply Full matrix by upper diagonal matrix; */
extern void mmultACh(int16 *m1, int16 *up, int16 *result, unsigned int16 rows, unsigned int16 columns);

/* perform Householder update of Ch matrix using PSI*Ch , Q, */
extern void householder(int16 *Ch /*= int16 *PSICh*/, int16 *Q, unsigned int16 dimx);

/* perform Givens update of Ch matrix using PSI*Ch , Q, */
extern void givens(int16 *Ch /*= int16 *PSICh*/, int16 *Q, unsigned int16 dimx);

/* perform Carlson update of Ch matrix using difz, R and xp, for size dimx*/
extern void carlson(int16 *difz, int16 *xp, int16 *Ch, int16 *R, unsigned int16 dimy, unsigned int16 dimx );
